var NotificationManager = (function (windowId, NotificationData) {
	return {
		_id: null,
		// 所有“通知”的id
		_idOfType: {},
		_windowId: windowId,
		
		/**
		 * @param name {String} LOGIN.ACCOUNT_NO_LOCAL_BOOKMARK
		 */
		create: function(element, fullName, data) {
			var self = this,
				parts = fullName.split('.'),
				groupName = parts[0],
				name = parts[1],
				group = NotificationData[groupName],
				notification = group[name];
				
			notification.fullName = fullName;
			notification.groupName = groupName;
			notification.name = name;
			notification.group = group;
				
			// 如果这个通知的显示，需要读config
			// 有的通知点击关闭按钮或者“我知道了”按钮，以及其他方式，都会触发“下次不再弹出”的逻辑
			// 在这里判断，而不是在调用 create 的入口判断，是为了只在一个地方判断
			if (notification.hasOwnProperty('CONFIG_KEY')) {
				var configKey = notification.CONFIG_KEY;
				// 读config
				qqbrowser.extension.builtin.config.get([configKey], function(jsonConfig) {
					var config = JSON.parse(jsonConfig),
						result = config[0];
					// 如果需要显示通知
					if (result[configKey]) {
						self._create(element, notification, data);
					}
				});
			} else {
				self._create(element, notification, data);
			}
		},
		// 新弹出一个“通知”
		_create: function(element, notification, data) {
			var mergedOptions = $.extend(true, {}, NotificationData.options, notification.group.options, typeof notification.options === 'function' ? notification.options(data) : notification.options),
				$element = $(element),
				offset = $element.offset(),
				width = $element.outerWidth(),
				height = $element.outerHeight(),
				halfWidth = width >> 1,
				halfHeight = height >> 1;

			this.destroyByGroup(notification.groupName);
			
			// 只显示一次的通知
			if (notification.ONCE) {
				var config = {};
				config[notification.CONFIG_KEY] = false;
				qqbrowser.extension.builtin.config.set(config, function() {});
			}
			
			switch (mergedOptions.arrow._customPoint.x) {
				case 'left':
					mergedOptions.arrow.point.x = offset.left;
					break;
					
				case 'center':
					mergedOptions.arrow.point.x = offset.left + halfWidth;
					break;
					
				case 'right':
					mergedOptions.arrow.point.x = offset.left + width;
					break;
			}
			
			switch (mergedOptions.arrow._customPoint.y) {
				case 'top':
					mergedOptions.arrow.point.y = offset.top;
					break;
					
				case 'center':
					mergedOptions.arrow.point.y = offset.top + halfHeight;
					break;
					
				case 'bottom':
					mergedOptions.arrow.point.y = offset.top + height;
					break;
					
				default:
			}
			
			// _customPoint不需要传给API
			delete mergedOptions.arrow._customPoint;
	
			qqbrowser.js.logic.tipManager.hideTooltip();
			this._id = this._idOfType[notification.fullName] = qqbrowser.tip.create(this._windowId, mergedOptions);
	
			if (mergedOptions._dataReportId) {
				qqbrowser.extension.builtin.statistics.increase(mergedOptions._dataReportId);
				delete mergedOptions._dataReportId;
			}
		},
		// 销毁通知
		destroy: function(id) {
			qqbrowser.tip.destroy(id);
		},
		// 销毁指定类型的“通知”
		destroyByType: function(fullName) {
			if (this._idOfType.hasOwnProperty(fullName)) {
				qqbrowser.tip.destroy(this._idOfType[fullName]);
				delete this._idOfType[fullName];
			}
		},
		destroyByGroup: function(groupName) {
			var self = this;
			
			Cube.Object.getKeys(NotificationData[groupName]).forEach(function(name) {
				self.destroyByType(groupName + '.' + name);
			});
		},
		// 销毁所有的“通知”
		destroyAll: function() {
			for (var fullName in this._idOfType) {
				qqbrowser.tip.destroy(this._idOfType[fullName]);
			}
			this._idOfType = {};
		}
	};
})(qqbrowser.window.currentId(), NotificationData);